#!/usr/bin/perl

$last_pid = $$;
$first_pid = $last_pid + 1;

for (;;) {

    # Fork a child processes and wait until the child terminates.
    ($pid = fork()) < 0 && die "cannot fork: $!\n";
    $pid == 0 && exit;
    wait;

    # Update visible process list, filling PID gaps with /proc information.
    $pids_seen[$pid] = 1;
    if ($last_pid + 1 < $pid - 1) { check_existing_processes(); }
    print "(time ", time(), " PID $pid)\n" unless ($pid % 1000);

    # The maximal process ID, and how many times we reached it.
    if ($pid > $max_pid) { $max_pid = $pid; } 
    if ($last_pid > $pid) { $wrapped_around++; }
    $last_pid = $pid;

    # Report findings when we complete two passes over the entire PID range.
    if ($wrapped_around > 1 && $pid >= $first_pid) {
	print "Maximal PID: $max_pid\n";
	for $pid (0..$max_pid) { report_missing($pid) if !$pids_seen[$pid]; }
	exit 0;
    }
}

# Report missing processes

sub report_missing {
    my($pid) = (@_);

    print "Missing PID: $pid\n";
    print "Process group $pid: ", join(' ', sort keys %{$pgid_seen[$pid]}), "\n"
	if defined $pgid_seen[$pid];
    print "POSIX session $pid: ", join(' ', sort keys %{$ssid_seen[$pid]}), "\n"
	if defined $ssid_seen[$pid];
}

# Portable version (Solaris, Linux)

sub check_existing_processes {
    my($pid, $pgid, $ssid);

    while(<`/bin/ps -ej`>) {
	s/^\s+//;
	($pid, $pgid, $ssid) = split(/\s+/);
	$pids_seen[$pid] = $pgid_seen[$pgid]{$pid} = $ssid_seen[$ssid]{$pid} = 1;
    }
}

# Linux-specific version
#
#sub check_existing_processes {
#    my($junk, $pid, $pgid, $ssid);
#
#    opendir(PROC, "/proc") || die "cannot open /proc: $!\n";
#    for $pid (grep /^[0-9]+$/, readdir(PROC)) { 
#	$pids_seen[$pid] = $pid;
#	if (open(STAT, "/proc/$proc/stat")) {
#	    if ((($junk, $junk, $junk, $junk, $pgid, $ssid) = split(/\s+/, <STAT>)) > 0) {
#		$pgid_seen[$pgid]{$proc} = 1;
#		$ssid_seen[$ssid]{$proc} = 1;
#	    }
#	    close(STAT);
#	}
#    }
#}
