#!/usr/local/bin/perl -s
#
# Open /dev/mem or /dev/kmem and read megabyte sized chunks.  Ignore errors,
# just seek and read 1 chunk at a time.
#
#       Usage: $0 [-k] [-d] N
#
# Where "N" is the number of meg chunks to read.  The -k flag tells it to
# read from kmem, else (by default) it reads /dev/mem.  -d is debug.
#

$block_length = 1024*1024;

$ARGV[0] = "1024" unless $#ARGV >= 0;   # get 1 GB of memory

if ($k) {
        die "Can't open /dev/kmem\n" unless open(ARG, "/dev/kmem");
        warn "Reading /dev/kmem\n";
        }
else { die "Can't open /dev/mem\n" unless open(ARG, "/dev/mem"); }

# for this many megabytes of data
for $n (0..($ARGV[0]-1)) {
        $position = $n * $block_length;
        seek(ARG,$position,0);
        if (($bytes_read = sysread(ARG, $block, $block_length))) {
        	print "\nKKK $bytes_read => $n:\n" if $d;
        	print $block;
		$total_bytes_read += $bytes_read;
		}
        }

warn "successfully read $total_bytes_read bytes\n";

