#!/usr/bin/perl -s

$debug = 1 if $d;

use Time::Local;
while (<>) {
    if (/^\$DATE/) { $dump_time = &parse_date(); next; }

    # look for interesting DNS records
    ($r, $ttl, $type) = &parse_record_data();
    next unless $r =~ /^[-._a-zA-Z0-9]+$/;

    # get the initial TTL from the authority record
    open(HOST, "host -v -t soa $r|") || die "Can't run host\n";

    $init_ttl = "";
    while (<HOST>) {
        if (/^\s+(\d+)\s*;\s*minimum ttl/i) { $init_ttl = $1; last; }
    }
    close(HOST);

    # save the difference between the two
    if ($init_ttl > $ttl) {
        $t = $dump_time - ($init_ttl - $ttl);
	if (! defined($time{"$t,$type"})) { $time{"$t,$type"} = $r; }
	else { $time{"$t,$type"} .= "\n" . " " x 29 . "$r"; }
    }
}

# output the sorted logs
for $_ (sort keys %time) {
    ($time, $type) = split(/,/, $_);
    print localtime($time) . " ($type) " . $time{"$_"} . "\n";
}

# parse the BIND date format
sub parse_date {

    ($x, $time) = split();
    ($y, $mon, $mday, $h, $min, $s) = 
	($time =~ m/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/);

    $mon = $mon - 1;
    $y = $y - 1900;

    return timegm($s, $min, $h, $mday, $mon, $y);

}

sub parse_record_data {
    my($type, $r, $ttl, $ip, $o1, $o2, $o3, $o4);

    # ignore comments
    return ("0", "0") if /^\s*;/;

    chop;
    ($type = $_) =~ s/.*\d+\s+(A|PTR|MX|NS|\\-AAAA)\s+.*/$1/;

    print "Record Type =>$type<= => $_\n" if $debug;

    # if ($type eq "A" || $type eq "PTR" || $type eq "\\-AAAA") {
    if ($type eq "A" || $type eq "PTR") {
	print "LN $_\n" if $debug;

	($r, $ttl, $type, $ip) = m/(.*)\s+(\S+)\s+(\S+)\s+(\S+)$/;

	print "Results => $r & $ttl\n" if $debug;

	if ($r =~ /^\s*$/) {
	    ($o1, $o2, $o3, $o4) = split(/\./,  $ip);
	    $r = "$o4.$o3.$o2.$o1.in-addr.arpa.";
	}
    }

    print "RESULTS => $r & $ttl\n" if $debug;

    return($r, $ttl, $type);

}
