#!/usr/bin/perl

# Run output through "sort +0 +1 +2 +3 +9" for pretty display.

die "Usage: $0 bodyfile journaldumpfile\n" unless $#ARGV eq 1;

#
# Get the inode to filename mapping.
#
open(BODY, $ARGV[0]) || die "cannot open $ARGV[0]: $!\n";
while(<BODY>) {
    ($junk, $path, $junk, $ino, $junk) = split(/\|/, $_);
    $filename{$ino} = $path;
}
close(BODY);

#
# Do the output fomatting
#
open(DEBUGFS, "perl ripdebugfs.pl $ARGV[1] | sort -u |") 
	|| die cannot run "perl ripdebugfs.pl $ARGV[1] | sort -u\n";
while(<DEBUGFS>) {
    ($stamp, $size, $mac, $ls, $uid, $gid, $ino, $junk) = split(/\s+/, $_);
    ($path = $filename{$ino}) || ($path = $filename{$ino} = "<inode $ino>");
    printf "%s %10s %s %s %10s %10s %s\n", substr(scalar(localtime(hex($stamp))), 4), 
	$size, $mac, $ls, $uid, $gid, $path;
}
close(DEBUGFS);
