#!/usr/bin/perl

#$verbose=1;

%type_char = (
	'directory', 'd',
	'regular', '-',
	'symlink', 'l',
	'block special', 'b',
	'character special', 'c',
	'FIFO', 'p',
	'socket', 's',
	'bad type', '?');

while (<>) {
	if (/^\s+Inode:/) {
		@junk = split(/\s+/, $_);
		$ino = $junk[2];
		if ($junk[5] eq "Mode:") {
			$type = $type_char{"$junk[4]"};
		} else {
			$type = $type_char{"$junk[4] $junk[5]"};
			shift(@junk);
		}
		$mode = oct($junk[6]);
	} elsif(/^\s+User:\s+(\d+)\s+Group:\s+(\d+)\s+Size:\s+(\d+)/) {
		$uid = $1;
		$gid = $2;
		$size = $3;
	} elsif (/^\s+ctime:\s+(\S+)/) {
		$ctime = $1;
	} elsif (/^\s+atime:\s+(\S+)/) {
		$atime = $1;
	} elsif (/^\s+mtime:\s+(\S+)/) {
		$mtime = $1;
	} elsif (/^\s+Blocks:/) {
		next if ($type eq "?");
		next if ($ctime == 0);
		# Don't use mtime for time stamping; ctime is more accurate.
		# When ctime is less than atime, assume this was a file access.
		$stamp = $ctime > $atime ? $ctime : $atime;
		$mac = "";
		$mac .= ($stamp == $mtime ? "m" : ".");
		$mac .= ($stamp == $atime ? "a" : ".");
		$mac .= ($stamp == $ctime ? "c" : ".");
		$ls = "";
		$ls .= ($mode & 0400) ? 'r' : '-';
		$ls .= ($mode & 0200) ? 'w' : '-';
		$ls .= ($mode & 0100) ? 'x' : '-';
		$ls .= ($mode & 0040) ? 'r' : '-';
		$ls .= ($mode & 0020) ? 'w' : '-';
		$ls .= ($mode & 0010) ? 'x' : '-';
		$ls .= ($mode & 0004) ? 'r' : '-';
		$ls .= ($mode & 0002) ? 'w' : '-';
		$ls .= ($mode & 0001) ? 'x' : '-';
		print "$stamp $size $mac $type$ls $uid $gid $ino ", scalar(localtime($stamp)), "\n";
	}
}
