/*++
/* NAME
/*	convert_size 3
/* SUMMARY
/*	file/memory size conversion
/* SYNOPSIS
/*	#include <convert_size.h>
/*
/*	size_t	convert_size(string)
/*	const char *string;
/* DESCRIPTION
/*	This routine converts a file or memory "size" string into
/*	internal form.  The size is specified as a decimal number
/*	followed by an optional case-insensitive suffix that specifies
/*	a multiplication factor: 'k' (1024), M (1024*1024) or G
/*	(1024*1024*1024).
/* DIAGNOSTICS
/*	The result is -1 in case of error.
/* LICENSE
/* .ad
/* .fi
/*	The IBM Public Licence must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*--*/

/* System library. */

#include <stdlib.h>
#include <limits.h>
#include <stdio.h>

/* Application-specific. */

#include "convert_size.h"

/* convert_size - convert size to number */

size_t  convert_size(const char *str)
{
    char   *last;
    size_t  result;

    result = strtoul(str, &last, 10);
    if (*str == 0 || last == str)
	return (-1);
    if (*last == 0)
	return (result);
    if (*last == 'k' || *last == 'K')
	return (result * 1024);
    if (*last == 'm' || *last == 'M')
	return (result * 1024 * 1024);
    if (*last == 'g' || *last == 'G')
	return (result * 1024 * 1024 * 1024);
    return (0);
}
