/*++
/* NAME
/*	make_template 3
/* SUMMARY
/*	fill some buffer with some pattern
/* SYNOPSIS
/*	#include <make_template.h>
/*
/*	char	*make_template(seed, seed_len, buffer_len)
/*	const char *seed;
/*	int	seed_len;
/*	size_t	buffer_len;
/* DESCRIPTION
/*	This routine fills a block of memory with a repeating
/*	pseudo-random pattern of 32 ASCII hexadecimal characters.
/* DIAGNOSTICS
/*	Fatal error: insufficient memory.
/* LICENSE
/* .ad
/* .fi
/*	The IBM Public Licence must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*--*/

/* System library. */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

/* Application-specific. */

#include "global.h"
#include "md5.h"
#include "make_template.h"

#define MD5_HASH_LENGTH 	16	/* MD5 output buffer */

/* crunch - compute MD5 of input and convert to hexadecimal */

const static char *crunch(const char *buf, size_t len)
{
    MD5_CTX md;
    unsigned char sum[MD5_HASH_LENGTH];
    static char result[2 * MD5_HASH_LENGTH + 1];
    static char hex[] = "0123456789abcdef";
    int     i;

    MD5Init(&md);
    MD5Update(&md, buf, len);
    MD5Final(sum, &md);

    for (i = 0; i < MD5_HASH_LENGTH; i++) {
	result[2 * i] = hex[(sum[i] >> 4) & 0xf];
	result[2 * i + 1] = hex[sum[i] & 0xf];
    }
    return (result);
}

/* make_template - fill memory with unique pattern */

char   *make_template(const char *seed, int seed_len, size_t buffer_len)
{
    char   *template;
    char   *cp;
    const char *md;
    char   *last;

    if ((template = malloc(buffer_len)) == 0) {
	fprintf(stderr, "No memory for template buffer!\n");
	exit(1);
    }
    md = crunch(seed, seed_len);
    last = template + buffer_len - MD5_HASH_LENGTH;
    for (cp = template; cp <= last; cp += MD5_HASH_LENGTH)
	memcpy(cp, md, MD5_HASH_LENGTH);
    return (template);
}
