#!/usr/bin/perl

# plot-average100.pl - plot average of memdecay measurements in one file
#
# usage: plot-average100.pl filename (output in filename.average100.pbm)
#
# Each input file is a concatenation of memdecay runs. The program
# produces one plot with the average of all runs in each input file. 
# Only the first 100 dots are shown.

$tempfile = "plot-average100.tmp";

for $file (@ARGV) {

    # Produce one plot per input file.

    open(IN, $file) || die "open $file: $!\n";
    open(TMP, ">$tempfile") || die "open $tempfile: $!\n";

    # First, compute the averages.

    while (<IN>) {
	    chop;
	    @fields = split(/\s+/);
	    # Start of a new memdecay run.
	    if ($fields[2] eq "start") {
		$count = 0;
		$base = $fields[1];
	    } 
	    # Update stats for another sample.
	    else {
		$fields[2] -= 2;
		$time[$count] += $fields[1] - $base;
		$hits[$count] += $fields[2];
		$seen[$count]++;
		$count++;
	    }
    }
    for ($count = 0; $count < 100 && defined($seen[$count]); $count++) {
	    printf TMP "%.1f %.1f\n", $time[$count]/$seen[$count], $hits[$count]/$seen[$count];
    }
    close(IN);
    close(TMP);

    # Then, plot the stuff

    system <<EOF
    gnuplot <<EOF

    set terminal pbm
    set output "$file.average100.pbm"

    set size 1, 1
    set origin 0, 0
    #set yrange [-300:0]
    #set zrange [0:1000]
    set logscale y
    #set xtics 100
    #set ytics 1,10,10000
    #set mxtics 10
    #set nomytics
    set xlabel "time (seconds)"
    set ylabel "surviving data (kbytes)"

    plot "$tempfile" using 1:2 title "averaged memory decay, file $file"

EOF
;

    # Display the graph

    system("rm -f $tempfile; xv $file.average100.pbm");

}
