#!/usr/bin/perl

# plot-multi100.pl - plot all memdecay measurements in one file
#
# usage: plot-multi100.pl [-s style] filename (output in filename.multi100.pbm)
#
# Each input file is a concatenation of memdecay runs. The program
# produces one plot that shows each individual run as a series of dots.
# Only the first 100 dots of each run are shown.

require "getopts.pl";

$opt_s = "lines";
#$opt_s = "dots";

&Getopts("s:");

for $file (@ARGV) {

    # Produce one plot per input file.

    open(IN, $file) || die "open $file: $!\n";

    $gnuplot = <<EOF
    gnuplot <<EOF
    set terminal pbm
    set output "$file.multi100.pbm"

    set size 1, 1
    set origin 0, 0
    set yrange [0.8:1200]
    set xrange [0:900]
    set logscale y
    #set xtics 100
    #set ytics 1,10,10000
    set mytics 10
    #set mxtics 10
    #set nomytics
    set xlabel "time (seconds)"
    set ylabel "surviving data (kbytes)"
    plot \\
EOF
    ;

    # Split the input into individual runs.

    while (<IN>) {
	    chop;
	    @fields = split(/\s+/);
	    # Start of a new memdecay run.
	    if ($fields[2] eq "start") {
		close(OUT);
		$run_length = 0;
		$time_base = $fields[1];
		$path = sprintf("plot-multi100.%03d.tmp", $fileno++);
		push(@files, $path);
		open(OUT, ">$path");
	    } 
	    # Update stats for another sample.
	    else {
		$fields[2] -= 2;
		if ($run_length < 100) {
		    printf OUT "%d %d\n", $fields[1] - $time_base, $fields[2];
		    $run_length++;
		}
	    }
    }
    close(OUT);
    
    # Finish the gnuplot job.

    $final = pop (@files);
    for $path (@files) {
	$gnuplot .= "\"$path\" using 1:2 title \"\" with $opt_s, \\\n";
    }
    $gnuplot .= "\"$final\" using 1:2 title \"memory decay of individual runs, file $file\" with $opt_s\n";

    system("$gnuplot");
    system("rm -f plot-multi100.*.tmp; xv $file.multi100.pbm");
}
