#!/usr/bin/perl

# ncc - minimal netcat client in Perl.
# Usage: ncc host port.

use IO::Socket;
$SIG{PIPE} = 'IGNORE';
$buflen = 102400;

die "usage: $0 host port\n" unless ($host = shift) && ($port = shift);

die "connect to $host:$port: $!\n" unless
    $sock = new IO::Socket::INET(PeerAddr => $host, PeerPort => $port,
                                 proto => 'tcp');

while (($count = sysread(STDIN, $buffer, $buflen)) > 0) {
    die "socket write error: $!\n" 
        unless syswrite($sock, $buffer, $count) == $count;
}
die "socket read error: $!\n" if $count < 0;
die "close socket: $!\n" unless close($sock);
