 /*
  * rprobe - brute force probe address space to find out if /dev/mem behaves
  */
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <error.h>

void    usage(void)
{
    error("usage: %s step size", progname);
}

int     main(int argc, char **argv)
{
    unsigned long step;
    unsigned long size;
    unsigned long pos;
    int     ch;

    progname = argv[0];

    if (argc != 3)
	usage();
    if ((step = strtoul(argv[1], (char **) 0, 10)) <= 0)
	usage();
    if ((size = strtoul(argv[2], (char **) 0, 10)) <= 0)
	usage();

    for (pos = 0; pos < size; pos += step) {
	if (lseek(0, (off_t) pos, SEEK_SET) < 0)
	    error("lseek(0, %lu, SEEK_SET): %m", pos);
	printf("%lu %d\n", pos, read(0, &ch, 1));
    }
    exit(0);
}
